#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Res_Fileversion=1.6.0.0
#AutoIt3Wrapper_Res_requestedExecutionLevel=requireAdministrator
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
;
; KissCloneHunter
; Based on CloneHunter 2.2 code
; Designed and created by Fuhrmanator@gmail.com, 2006-03-15
;
; Updated for 1.12 by PortalDeamon000 2008-09-30
; Updated for 1.12 regular D2 2008-12-05

#include <String.au3>
#include <GuiConstants.au3>
#include <Date.au3>
#include <NomadMemory.au3>
#include <WindowsConstants.au3>
#include <ProgressConstants.au3>

Const $VersionInfo = 'KissCloneHunter 1.6'

Global $GameCount = 0
;; handle to controls in the lobby screen - from R1CH
Global $OFFSET_D2MULTI_SCREEN = 0x6FA09154
Global $OFFSET_D2MULTI_IPADDRESS_ASCII = 0x6FA2B1F8
Global $OFFSET_D2MULTI_LAST_CHAT_MSG = 0x6FBCFC40
Global $OFFSET_GAME_PING = 0x6FBB32BC

Global $MESSAGE_DIABLO_WALKS_THE_EARTH = "Diablo Walks the Earth"
Global $MESSAGE_STONES_OF_JORDAN_SOLD = "Stones of Jordan Sold to Merchants"

Global $LOBBY_MAIN_CREATE_X            = 600
Global $LOBBY_MAIN_CREATE_Y            = 463
Global $LOBBY_MAIN_JOIN_X              = 706
Global $LOBBY_MAIN_JOIN_Y              = 463
Global $LOBBY_CREATE_HELL_X            = 706
Global $LOBBY_CREATE_HELL_Y            = 375
Global $LOBBY_CREATE_CREATE_GAME_X     = 684
Global $LOBBY_CREATE_CREATE_GAME_Y     = 420

$DebugForceFind = 0  ;; used for testing only

;$GameCreateDelay = 0
$UserUniqueGameName = 0
$UserUniqueGamePass = ""
$GameNumber = 0
$GameName = 0
$GamePass = 0
$CurrentIP = 0
$IPList = 0
$HuntSoundFile = @ScriptDir & '\diablo_hunt.wav'
$FoundSoundFile = @ScriptDir & '\tada.wav'
$WindowName = "classname=Diablo II"

;; GUI positioning
$GUIWindowWidth = 200
$GUIWindowHeight = 440
$GUIWindowX = 824
$GUIWindowY = 0

$MSG_TimeToNextGame = "Time left:"

Dim $HuntedIPs[4] ;; gets redimensioned later, but we need its scope here

$GameDurationSeconds = 180
$AdjustedGameLengthSeconds = 0

;; Note - some users (including the author) experienced, at times,
;; frequent "failed to join game" errors after a new game is created.
;; Increasing the value below might help, but my experience shows
;; that even at 10 seconds, the problem can still occur.
;; If the delay is too small (e.g., 1 second), "failed to join game"
;; errors occur almost every time. There is likely another reason
;; for this error when delay before new game is higher, possibly
;; packet-loss on the local ISP, using a character that was in a game
;; that recently crashed, etc.

$DelayBeforeNewGameSeconds = 5

;; generate a random letter (A-Z) plus a 3-digit number (100-999) for game name prefix
$UserUniqueGameName = Chr(64 + Random(1, 26, 1)) & Random(100, 999, 1) & "-"
$PrivateMessageRecipient = ""
$AntiIdleDelayMS = 30 * 1000  ;; 30 secs

; GUI - startup gui with update option
$startgui = GUICreate($VersionInfo, 300,100)
$button_1 = GuiCtrlCreateButton("Run", 10, 10, 100, 50)
$button_2 = GUICtrlCreateButton("Help - How to Use", 10, 65, 100, -1)
$button_3 = GuiCtrlCreateButton("Cancel", 180, 10, 100, 50)
$button_4 = GUICtrlCreateButton("Check For Updates", 180, 65, 100, -1)
GUISetState(@SW_SHOW,$startgui)

While 1
	$msg = GUIGetMsg()
	Select
		Case $msg = $button_1
			GUIDelete($startgui)
            ExitLoop
		Case $msg = $button_2
            ShellExecute("readme.txt")
		Case $msg = $button_3
            Exit
		Case $msg = $button_4
			_Update()
		Case $msg = $GUI_EVENT_CLOSE
            Exit
	EndSelect
WEnd

;; option param = 16 so window can be moved if needed, smaller font (10 pt?)
;GUIWindowOn ( $VersionInfo, $VersionInfo & ' by Fuhrmanator, based on code by Snarg', $GUIWindowWidth, $GUIWindowHeight, $GUIWindowX, $GUIWindowY, 16, "", 10 )

; cell positioning of all new GUI components
AutoItSetOption("GUICoordMode", 2)
AutoItSetOption("GUIOnEventMode", 1)

; GUI - make it resizable, and force it to top always
$maingui = GUICreate($VersionInfo, $GUIWindowWidth, $GUIWindowHeight, $GUIWindowX, $GUIWindowY, $WS_THICKFRAME, $WS_EX_TOPMOST + $WS_EX_TOOLWINDOW)

GUISetOnEvent($GUI_EVENT_CLOSE, "CLOSEClicked")

$IPListLabel = GUICtrlCreateLabel("Hunting IPs: ", 3, 3, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")

; Pause BUTTON
$PauseButton = GUICtrlCreateButton("Pause", -1, 0)
GUICtrlSetOnEvent( -1, "PauseButton")
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
$HuntPaused = 0
GUICtrlSetState( -1, $GUI_DISABLE)

; Timer PROGRESS
$ProgressLabel = GUICtrlCreateLabel($MSG_TimeToNextGame, -1, 0, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
$Progress = GUICtrlCreateProgress(-1, 0, $GUIWindowWidth - 10, 20, $PBS_SMOOTH)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetData(-1, 0)

; KEEP MINIMIZED checkbox
$MinimizedCheckbox = GUICtrlCreateCheckbox( "Do not bring D2 window to front", -1, 0, $GUIWindowWidth - 10)
;GUICtrlSetState ( -1, $GUI_CHECKED)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )

; INTERRUPT HUNT ON SOJ sales activity checkbox
$InterruptOnSalesCheckbox = GUICtrlCreateCheckbox( "Hold game on SoJ sale or Walk msg", -1, 0, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetState( -1, $GUI_CHECKED)

; Disable warning BEEP before activating a window
$DisableBeepCheckbox = GUICtrlCreateCheckbox( "Disable Warning Beep", -1, 0, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )

; Log of messages
$LogText = GUICtrlCreateEdit($VersionInfo & @CRLF & ' by Fuhrmanator, based on code by Snarg' & @CRLF & ' modified for 1.12 by PortalDeamon000' & @CRLF, -1, 0, $GUIWindowWidth - 10, $GUIWindowHeight - 170)
GUICtrlSetResizing($LogText, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKBOTTOM)

AutoItSetOption("WinTitleMatchMode", 4)  ;; class name, etc.

;;==================================================
;; Main code starts here
;;==================================================

;; VerifyDisplaySettings()

;; intro sound for cool (?) factor
SoundPlay($HuntSoundFile)

AskForAllInfo()

; Display main GUI window
GUISetState(@SW_SHOW,$maingui)

;; must have this priv to read d2's memory
_SetPrivilege ("SeDebugPrivilege", 1)

VerifyLobbyScreenUp()

GUICtrlSetData($IPListLabel, "Hunting IPs: " & $IPList)

while (1)
    
    CreateGame()
	Sleep(500)
	_SendMinimized($WindowName, '{TAB}')  ;; turn on the info to display gamename/etc

    ;; check to see if current game's IP is in list of hunted IPs
    $CurrentIP = Read_Diablo_Memory (GetD2ProcessID(), $OFFSET_D2MULTI_IPADDRESS_ASCII, 'char[16]')
    AppendLineToLogText("Joined game IP: " & $CurrentIP & " at " & _NowCalc())
    
    If IsIPFound($CurrentIP) Then
        AckHuntedIPFound()  ;; never returns
    EndIf

	;==============================
	; prepare to wait in the game
	;==============================
	
    ;; calculate the game time in seconds
	$AdjustedGameLengthSeconds = $GameDurationSeconds - $DelayBeforeNewGameSeconds

    ;; clear the last message seen on the D2 client
    $oldMessage = ""
    
    UnPause()
    HotKeySet("{PAUSE}", "PauseButton")
    GUICtrlSetState($PauseButton, $GUI_ENABLE)

    ;; wait in the game, displaying the time remaining and the progress bar
    For $sleepSecond = $AdjustedGameLengthSeconds To 0 Step - 0.5
        
        $percentComplete = Int(100 * ($AdjustedGameLengthSeconds - $sleepSecond) / $AdjustedGameLengthSeconds)
        
        GUICtrlSetData($ProgressLabel, $MSG_TimeToNextGame & Int($sleepSecond) & " sec.")
        GUICtrlSetData($Progress, $percentComplete)
        
        ;; beep to signal that the timer's about to run out
        If $sleepSecond < 5 And $sleepSecond = Int($sleepSecond) Then
            MyBeep()
        EndIf
        
        Sleep(500)
        
        ;; if the user pressed the pause button, the variable will be set
        While $HuntPaused = 1
            Sleep(500)
        WEnd
        
        ;; check for SOJ sales and/or Diablo Walks here,
        ;; in case it happens while we're waiting for next game
        ;; (that would be bad to ignore it!)
        If GetLastChatMessage() <> $oldMessage Then
            $oldMessage = GetLastChatMessage()
            AppendLineToLogText("New msg -> " & $oldMessage)
            ;; only check for messages if user has requested
            If (GUICtrlRead($InterruptOnSalesCheckbox) = $GUI_CHECKED) Then
                If StringLeft($oldMessage, StringLen($MESSAGE_DIABLO_WALKS_THE_EARTH)) = $MESSAGE_DIABLO_WALKS_THE_EARTH Then
                    InterruptHunt()
                ElseIf StringInStr($oldMessage, $MESSAGE_STONES_OF_JORDAN_SOLD, 1) Then
                    InterruptHunt()
                EndIf
            EndIf
        EndIf
        
    Next
    
    HotKeySet("{PAUSE}")  ;; unset hot key
    GUICtrlSetState($PauseButton, $GUI_DISABLE)
    GUICtrlSetData($Progress, 0)
    
    ExitGame()

    AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
    Sleep($DelayBeforeNewGameSeconds * 1000)
    
WEnd


; =========== Subroutines ===============

Func VerifyDisplaySettings()
    
    If @DesktopWidth < 1024 Or @DesktopHeight < 768 Or @DesktopDepth < 32 Then
        MsgBox(16 + 0, "Display settings incorrect", "Sorry. For this program to function properly, " & @CRLF & "your screen's resolution must be at least 1024 x 768" & @CRLF & "and your screen's color depth must be exactly 32 bits.")
        Exit
    EndIf
    
EndFunc   ;==>VerifyDisplaySettings 

; ===========================================
Func AskForAllInfo()
    
    AskIPAddresses()
    AskGameDuration()
    AskGamePrefix()
	AskGamePassword()
    AskMessageRecipient()
    AskToPrepareClient()
    
EndFunc   ;==>StartDiabloNoAutoLogin 

; ===========================================

Func AskIPAddresses()
    
    ;; accept at least one IP to search for
    Do
        $InputIPList = InputBox($VersionInfo & ": IP List", "Please enter a list of IPs to search for, separated by commas. Only enter the last part of an IP address, not the entire IP address.", "66, 141", " M")
        
        If @error <> 0 Then
            Exit
        EndIf
        
        ; msgbox(0, "$InputIPList", $InputIPList)
        
        $InputIPList = StringStripWS($InputIPList, 8)  ;; strip all spaces
        
        ; msgbox(0, "$InputIPList", $InputIPList)
        
        $SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
        
    Until $SplitIPs[0] >= 1
    
    ;; first element of array after Split is number of returned elements
    ReDim $HuntedIPs [$SplitIPs[0]]
    $IPList = ""
    
    For $r = 1 To UBound($SplitIPs) - 1
        
        ; msgbox(0, "$SplitIPs[$r]", $r & " = " & $SplitIPs[$r])
        
        $HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
        If $IPList = "" Then
            $IPList = $SplitIPs[$r]  ;; init to first split IP
        Else
            $IPList = $IPList & ", " & $SplitIPs[$r]
        EndIf
        
    Next
    
    
EndFunc   ;==>AskIPAddresses 

; ===========================================

Func AskGameDuration()
    
    ;; Ask how many seconds a game should last
    Do
        $GameDurationSeconds = InputBox($VersionInfo & ": Game duration", "Please enter how many seconds (at least 10) a game should last. Note: 180 seconds is generally a safe number to avoid getting IP banned after many tries.", $GameDurationSeconds, " M")
        If @error <> 0 Then
            Exit
        EndIf
        
    Until $GameDurationSeconds >= 10
    
EndFunc   ;==>AskGameDuration 

; ===========================================

Func AskGamePrefix()
    
    ;; Ask for unique game name
    Do
        $UserUniqueGameName = InputBox($VersionInfo & ": Game name prefix", "Please enter a prefix for the games to use (should be unique)", $UserUniqueGameName, " M10")
        If @error <> 0 Then
            Exit
        EndIf
        
    Until $UserUniqueGameName <> ""
    
EndFunc   ;==>AskGamePrefix 

; ===========================================

Func AskGamePassword()
    
    ;; Ask for unique game password
    Do
        $UserUniqueGamePass = InputBox($VersionInfo & ": optional game password", "Entering a password here will set a custom password.  Leave blank for default game number as password.", $UserUniqueGamePass, " 10")
        If @error <> 0 Then
            Exit
        EndIf
        
    Until $GameDurationSeconds >= 10
    
EndFunc   ;==>AskGamePassword 

; ===========================================

Func AskMessageRecipient()
    
    ;; Ask how many seconds a game should last
    Do
        $PrivateMessageRecipient = InputBox($VersionInfo & ": optional notification", "Please enter the Battle.net account ID that should receive a private message if an IP has been found (do not include the *). Leave blank for no message.", $PrivateMessageRecipient)
        If @error <> 0 Then
            Exit
        EndIf
        
    Until $GameDurationSeconds >= 10
    
EndFunc   ;==>AskMessageRecipient 

; ===========================================

Func AskToPrepareClient()
    
    $startResponse = MsgBox(1, $VersionInfo & ": Prepare D2 Client", "I will begin searching for the following IPs: " & $IPList & @CRLF & @CRLF & "Note: To stop me at any time, click my AutoIt icon in the system tray for a menu of options." & @CRLF & @CRLF & "Before continuing, make sure you have done the following:" & @CRLF & "1. Start Diablo in a separate window (-w option) and make sure the resolution is set to 800x600." & @CRLF & "2. Log in to your realm." & @CRLF & "3. Open a character that can create Hell-level games (make sure the Create button is on the screen).")
    
    If $startResponse = 2 Then  ;; cancel button
        Exit
    EndIf
    
EndFunc   ;==>AskToPrepareClient 

; ===========================================

Func ActivateRestoreDiabloWindow()
    
    WinActivate($WindowName)
    WinWaitActive($WindowName)
    WinSetState($WindowName, "", @SW_RESTORE)
    ;;Sleep ( 500 )
    AutoItSetOption("MouseCoordMode", 1)  ;; 1 is absolute
    WinMove($WindowName, '', 0, 0)
    ;;Sleep ( 500 )
    
EndFunc   ;==>ActivateRestoreDiabloWindow 

; ===========================================

Func PauseButton()
    
    If $HuntPaused = 0 Then
        Pause()
    Else
        UnPause()
    EndIf
    
EndFunc   ;==>PauseButton

; ===========================================

Func Pause()
    
    $HuntPaused = 1
    GUICtrlSetData($PauseButton, "Resume")
    $PausedText = GUICtrlRead($ProgressLabel) & " (paused)"
    GUICtrlSetData($ProgressLabel, $PausedText)
    GUICtrlSetBkColor($Progress, 0xff0000)
    
EndFunc   ;==>Pause

; ===========================================

Func UnPause()
    
    $HuntPaused = 0
    GUICtrlSetData($PauseButton, "Pause")
    $PausedText = ""
    GUICtrlSetBkColor($Progress, 0xffffff)
    ;; no need to update the label - it will get updated once game resumes
    
EndFunc   ;==>UnPause

; ===========================================

Func CloseClicked()
    
    Exit
    
EndFunc   ;==>CloseClicked

; ========================================

Func CreateGame()
    
    Do
        $GameCount = $GameCount + 1
        AppendLineToLogText( "Current try: " & $GameCount)
        If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then ActivateRestoreDiabloWindow()
        ;; click Create button
        AutoItSetOption("MouseCoordMode", 2)  ;; 0 is relative, 1 is absolute, 2 = relative coords to the client area of the active window
        
		;; click "Join" button (to make sure "Create" will be active; it can be grayed out after create fails)
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y)
		Sleep(400)
		;; click "Create" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_CREATE_X, $LOBBY_MAIN_CREATE_Y)
		Sleep(400)
        ;; click Hell level button
        _MouseClickMinimized($WindowName, "left", $LOBBY_CREATE_HELL_X, $LOBBY_CREATE_HELL_Y)
		Sleep(400)
        
        ;; make game name and password
        $GameNumber = $GameNumber + 1
        $GameName = $UserUniqueGameName & $GameNumber
		if $UserUniqueGamePass = "" Then
			$GamePass = $GameNumber
		Else
			$GamePass = $UserUniqueGamePass
		EndIf
        AppendLineToLogText( "Trying to create " & $GameName & "//" & $GamePass)
        
        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')
        ;; FOR DEBUGGING -> _SendMinimized($WindowName, $GamePass)
        
    Until IsGameCreated() = 1
    
    Return
    
EndFunc   ;==>CreateGame 

; ========================================

;; logic is a bit strange here...

Func IsGameCreated()
    
    ; init a timer, so we can see how long this takes (for recovery)
    $TimerStart = TimerInit()
    
    ;; WaitForChangeInManaBall (1000, 7)  ;; milliseconds between checks, number of retries
    
    $RetryCount = 0
    Do
        If IsGameActive() Then
            Return 1
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30
    
    
    ; Assume now that Game creation has failed and try to recover
    ; we only deal with "failed to join game" errors, so we assume that happened.
    ; All we can do is wait the $GameDurationSeconds , because a game was created that we couldn't join
    $InitSecondsRemaining = ($GameDurationSeconds - Int(TimerDiff($TimerStart) / 1000))
    AppendLineToLogText("Problem creating and joining game... Waiting " & $InitSecondsRemaining & " seconds, because game was likely created and I was unable to join it.")
    Do
        $SecondsRemaining = ($GameDurationSeconds - Int(TimerDiff($TimerStart) / 1000))
        $percentComplete = Int(100 * ($InitSecondsRemaining - $SecondsRemaining) / $InitSecondsRemaining)
        
        GUICtrlSetData($ProgressLabel, "Time before next game:" & $SecondsRemaining & " sec.")
        GUICtrlSetData($Progress, $percentComplete)
        
        ;; beep to signal that the timer's about to run out
        If $SecondsRemaining <= 5 Then
            MyBeep()
        EndIf
        
        Sleep(1000)
        
    Until (TimerDiff($TimerStart) > $GameDurationSeconds * 1000)
    
    VerifyLobbyScreenUp()
    
    Return 0
    
EndFunc   ;==>IsGameCreated 

; ========================================

Func IsLobbyScreenUp()
    
    If GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED Then ActivateRestoreDiabloWindow()
    
    $ProcessID = GetD2ProcessID()
    
    Local $DllInformation = _MemoryOpen ($ProcessID)
    If @error Then
        MsgBox(4096, "ERROR", "Failed to open memory.")
        Exit
    EndIf
    
    $Value = _MemoryRead ($OFFSET_D2MULTI_SCREEN, $DllInformation, 'dword')
    
    ;; MsgBox(4096, "Value", $Value)
    
    ;##################################
    ;Close the process.
    ;##################################
    _MemoryClose ($DllInformation)
    If @error Then
        MsgBox(4096, "ERROR", "Failed to close memory.")
        Exit
    EndIf
    
    If $Value <> 0 Then
        Return 1
    Else
        Return 0
    EndIf
    
EndFunc   ;==>IsLobbyScreenUp 

; ========================================

Func VerifyLobbyScreenUp()
    
    If Not IsLobbyScreenUp() Then
        Do
            $userResponse = MsgBox(5 + 32, $VersionInfo & ": Problem", "Either the Lobby Screen is not active in the Diablo II window, or the Create button is grayed out and I cannot create a game." & @CRLF & "Please make sure you've opened a character in Diablo and are waiting in the lobby screen, with the Create button present and enabled.")
            If $userResponse = 2 Then
                ;; user chose to cancel, exit...
                Exit
            EndIf
        Until IsLobbyScreenUp()
    Else
        ;; everything is good, continue on
    EndIf
    
EndFunc   ;==>VerifyLobbyScreenUp 

; ========================================

Func GetD2ProcessID()
    $ProcID = WinGetProcess($WindowName, "")
    If $ProcID = -1 Then
        MsgBox(4096, "ERROR", "Diablo Game appears not to be running. Exiting...")
        Exit
    EndIf
    Return $ProcID
EndFunc   ;==>GetD2ProcessID

; ========================================

Func IsGameActive()
    
    ;; if game is active, then the game ping will be > 0
    
    $ping = ReadGamePing()
    If $ping > 0 Then
        Return 1
    Else
        Return 0
    EndIf
    
EndFunc   ;==>IsGameActive 

; ========================================

Func ReadGamePing()

    Local $Value

    Local $ProcessID = GetD2ProcessID()
	$value = Read_Diablo_Memory($ProcessID, $OFFSET_Game_Ping, 'dword')

	Return $Value
    
EndFunc   ;==>ReadGamePing 

; ========================================

Func IsIPFound($IP)
    ;; find last "." in IP address
    $lastDot = StringInStr($IP, ".", 0, 3)
    ;; find last part of IP address
    $lastPart = StringMid($IP, $lastDot + 1)
    
    ;; search for last part of IP in the HuntedIP array
    If $DebugForceFind Then
        $HuntedIPIsFound = 1
    Else
        $HuntedIPIsFound = 0
    EndIf
    
    For $r = 0 To UBound($HuntedIPs) - 1
        ;; MsgBox(4096, 'Comparing', "Comparing '" & $HuntedIPs[$r] & "' to '" & $lastPart & "'")
        If $HuntedIPs[$r] = $lastPart Then $HuntedIPIsFound = 1
    Next
    Return $HuntedIPIsFound
EndFunc   ;==>IsIPFound

; ========================================

Func ExitGame()
    
    AppendLineToLogText( "Trying to exit game...")
    ; ControlSetText ( $VersionInfo, "", "Static1", "Hunting IPs: " & $IPList & @CRLF & "Current try: " & $GameCount &@CRLF & "Trying to exit game...")
    
    If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then
        ActivateRestoreDiabloWindow()
    EndIf
    
    ;; only try to exit if a game's not active
    
    If IsGameActive() Then
        _SendMinimized($WindowName, "{SPACE}{SPACE}{SPACE}")
        Sleep(100)
        
        AutoItSetOption("MouseCoordMode", 2)  ;; 0 is relative, 1 is absolute, 2 = relative coords to the client area of the active window
        _SendMinimized($WindowName, '{ESC}')
        Sleep(250)
        _MouseClickMinimized($WindowName, "left", 439, 259)  ;; coordinates of "Save and Exit Game"
		Sleep(100)
		_MouseClickMinimized($WindowName, "left", 439, 259)  ;; coordinates of "Save and Exit Game"
        
        ;; wait for screen to change
        $retries = 0
        While (Not IsLobbyScreenUp() And $retries < 20)
            Sleep(500)
            $retries = $retries + 1
        WEnd
        
    Else
        AppendLineToLogText( "Game is already inactive; attempting to continue without exiting.")
    EndIf
    
    VerifyLobbyScreenUp()
    Return
    
EndFunc   ;==>ExitGame 

; ========================================

Func AckHuntedIPFound()
    
    AppendLineToLogText("Hunted IP " & $CurrentIP & " has been found at " & _NowCalc() & @CRLF & "Game: " & $GameName & "//" & $GamePass)

    GUICtrlSetData($ProgressLabel, "Found IP " & $CurrentIP & "!")
    GUICtrlSetBkColor($ProgressLabel, 0x00FF00)

    ;; Give the user a chance to acknowledge the game has been found, repeating the sound
    Do
        SoundPlay($FoundSoundFile)
        AntiIdle()
        TrayTip("Success!!!", "Hunted IP " & $CurrentIP & " has been found!!!" & @CRLF & "Game name: " & $GameName & @CRLF & "Game password: " & $GamePass & @CRLF & "Currently anti-idling - click here ASAP to select Exit and begin anti-idling on your own.", $AntiIdleDelayMS, 1)
        ;; wait an additional 1-5 seconds
        Sleep($AntiIdleDelayMS + Random(1, 5, 1) * 1000)
    until (0)
    
    Exit
    
    Return
    
EndFunc   ;==>AckHuntedIPFound 

; ========================================

Func InterruptHunt()
    
    AppendLineToLogText("Interrupting hunt because of detected activity on current server.")
    
    ;; adjust the progress bar and Pause button
    GUICtrlSetState($PauseButton, $GUI_DISABLE)
    GUICtrlSetData($ProgressLabel, "Interrupted - SoJ sales activity detected...")
    GUICtrlSetBkColor($ProgressLabel, 0x00FF00)
    GUICtrlSetData($Progress, 0)
    
    ;; Give the user a chance to acknowledge the game is being held, repeating the sound
    Do
        SoundPlay($FoundSoundFile)
        AntiIdle()
        TrayTip("Possible success!!!", "Chat messages indicate activity on " & $CurrentIP & @CRLF & "Game name: " & $GameName & @CRLF & "Game password: " & $GamePass & @CRLF & "Currently anti-idling - click here ASAP to select Exit and begin anti-idling on your own.", $AntiIdleDelayMS, 1)
        ;; wait an additional 1-5 seconds
        Sleep($AntiIdleDelayMS + Random(1, 5, 1) * 1000)
    until (0)
    
    Exit
    
    Return
    
EndFunc   ;==>InterruptHunt 

; ============================================

Func AntiIdle()
    
    If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then ActivateRestoreDiabloWindow()
    
    If IsGameActive() Then
		;; anti-idle with random "vocal" message ("time to die!", etc.)
		_SendMinimized($WindowName, "{NUMPAD" & Random(0, 7, 1) & "}")
        SendSuccessMessage()
		_SendMinimized($WindowName, "{NUMPAD" & Random(0, 7, 1) & "}")
    Else
        AppendLineToLogText("Sorry. The game on the hunted IP " & $CurrentIP & " appears to have dropped (disconnected, crashed?) at " & _NowCalc())
        $userResponse = MsgBox(32, $VersionInfo & ": Problem", "Game " & $GameName & "//" & $GamePass & " appears to be lost (disconnected?). Check your Diablo II window.")
        Exit
    EndIf
    
EndFunc   ;==>AntiIdle 

; ============================================
Func SendSuccessMessage()
    
    _SendMinimized($WindowName, "{SPACE}{SPACE}{SPACE}")
    Sleep(250)
    
    ;; randomizing the message a bit with variable number of "!"
    
    If $PrivateMessageRecipient <> "" Then
        ;; note : if you don't bring the d2 window to front,
        ;; the success message (which is supposed to go to the
        ;; minimized window) doesn't work -
        ;; it stops after the first {enter}
        ActivateRestoreDiabloWindow()
        _SendMinimized($WindowName, "{ENTER}")
        Sleep(250)
        _SendMinimized($WindowName, "/m *" & $PrivateMessageRecipient & " Come to " & $GameName & "//" & $GamePass & " for a game on " & $CurrentIP & _StringRepeat("{!}", Random(1, 9, 1)))
        _SendMinimized($WindowName, "{ENTER}")
;~     Else
;~         _SendMinimized($WindowName, "{ENTER}")
;~         Sleep(250)
;~         _SendMinimized($WindowName, "{!}Woot" & _StringRepeat ( "{!}", RANDOM (1, 9, 1) ) & " I got a game on IP " & $CurrentIP & "{ENTER}")
    EndIf
    
EndFunc   ;==>SendSuccessMessage 

; ============================================

Func GetLastChatMessage()
    
    $Handle = _MemoryOpen (GetD2ProcessID())
    
    $pointer1 = _MemoryRead ($OFFSET_D2MULTI_LAST_CHAT_MSG, $Handle, 'dword')
    $pointer2 = _MemoryRead ($pointer1, $Handle, 'dword')
    $Temp = _MemoryReadWideString ($pointer2, $Handle, 'ushort[256]')
    
    _MemoryClose ($Handle)
    
    Return $Temp
    
EndFunc   ;==>GetLastChatMessage


; ============================================

Func AppendLineToLogText($TextToAppend)
    GUICtrlSetData($LogText, $TextToAppend & @CRLF, "a")
EndFunc   ;==>AppendLineToLogText

; ============================================

Func MyBeep()
    
    ;Found this on the AutoIt forums...
    
    ;Define             Value   Sound Alias
    ;Default beep       -1
    ;MB_OK              0x00    SystemDefault
    ;MB_ICONHAND        0x10    SystemHand
    ;MB_ICONQUESTION    0x20    SystemQuestion
    ;MB_ICONEXCLAMATION 0x30    SystemExclamation
    ;MB_ICONASTERISK    0x40    SystemAsterisk
    
    ;call BOOL MessageBeep(UINT uType);
	
	If (GUICtrlRead($DisableBeepCheckbox) = $GUI_UNCHECKED) Then
		DllCall("user32.dll", "int", "MessageBeep", "int", -1)
	EndIf
    
EndFunc   ;==>MyBeep 

;===============================================================================
;
; Function Name:  _MouseClickMinimized()
; Version added:  0.1
; Description:    Sends a click to window, not entirely accurate, but works
;                 minimized.
; Parameter(s):   $Window     =  Title of the window to send click to
;                 $Button     =  "left" or "right" mouse button
;                 $X          =  X coordinate
;                 $Y          =  Y coordinate
;                 $Clicks     =  Number of clicks to send
; Remarks:        You MUST be in "MouseCoordMode" 0 (cpf: or 2???) to use this without bugs.
; Author(s):      Insolence <insolence_9@yahoo.com>
;
;===============================================================================
Func _MouseClickMinimized($Window, $Button = "left", $X = "", $Y = "", $Clicks = 1)
    Local $MK_LBUTTON = 0x0001
    Local $WM_LBUTTONDOWN = 0x0201
    Local $WM_LBUTTONUP = 0x0202
    Local $MK_RBUTTON = 0x0002
    Local $WM_RBUTTONDOWN = 0x0204
    Local $WM_RBUTTONUP = 0x0205
    Local $WM_MOUSEMOVE = 0x0200
    Local $i = 0
    Select
        Case $Button = "right"
            $Button = $MK_RBUTTON
            $ButtonDown = $WM_RBUTTONDOWN
            $ButtonUp = $WM_RBUTTONUP
        Case $Button = "left"
            $Button = $MK_LBUTTON
            $ButtonDown = $WM_LBUTTONDOWN
            $ButtonUp = $WM_LBUTTONUP
        Case Else  ;; CPF
            ;; illegal number of parameters?
            MsgBox(32, $VersionInfo & ": Problem", "_MouseClickPlus() called with bad number of params?")
            Exit
    EndSelect
    ;; makes no sense to send click to minimized window with current mouse coordinates
    If $X = "" Or $Y = "" Then
        ;; illegal number of parameters?
        MsgBox(32, $VersionInfo & ": Problem", "_MouseClickPlus() called with bad number of params?")
        Exit
    EndIf
    For $i = 1 To $Clicks
        DllCall("user32.dll", "int", "SendMessage", _
                "hwnd", WinGetHandle($Window), _
                "int", $WM_MOUSEMOVE, _
                "int", 0, _
                "long", _MakeLong($X, $Y))
        DllCall("user32.dll", "int", "SendMessage", _
                "hwnd", WinGetHandle($Window), _
                "int", $ButtonDown, _
                "int", $Button, _
                "long", _MakeLong($X, $Y)) 
        DllCall("user32.dll", "int", "SendMessage", _
                "hwnd", WinGetHandle($Window), _
                "int", $ButtonUp, _
                "int", $Button, _
                "long", _MakeLong($X, $Y)) 
    Next
EndFunc   ;==>_MouseClickMinimized

;===============================================================================
;
; Function Name:  _MouseMoveMinimized()
; Version added:  0.1
; Description:    Sends a move message to window, works minimized.
; Parameter(s):   $Window     =  Title of the window to send click to
;                 $X          =  X coordinate
;                 $Y          =  Y coordinate
; Remarks:        You MUST be in "MouseCoordMode" 0 (cpf: or 2???) to use this without bugs.
; Author(s):      Cris Fuhrman (based on code by Insolence <insolence_9@yahoo.com>)
;
;===============================================================================
Func _MouseMoveMinimized($Window, $X = "", $Y = "")
    Local $WM_MOUSEMOVE = 0x0200
    Local $i = 0
    
    If $X = "" Or $Y = "" Then
        MsgBox(32, $VersionInfo & ": Problem", "_MouseMovePlus() called with bad number of params?")
        Exit
    EndIf
    
    DllCall("user32.dll", "int", "SendMessage", _
            "hwnd", WinGetHandle($Window), _
            "int", $WM_MOUSEMOVE, _
            "int", 0, _
            "long", _MakeLong($X, $Y)) 
EndFunc   ;==>_MouseMoveMinimized

;===============================================================================
;
; Function Name:  _SendMinimized()
;===============================================================================
Func _SendMinimized($Window, $keys)
    ;; note : testing with D2 shows that sending {ENTER} to open the chat screen
    ;;   requires that the D2 window be shown. Otherwise, all other keystrokes
    ;;   seem to be ingored, and the client stays in the chat mode.
    ControlSend($Window, "", "", $keys)
    
EndFunc   ;==>_SendMinimized

;========================================================

Func _MakeLong($LoWord, $HiWord)
    Return BitOR($HiWord * 0x10000, BitAND($LoWord, 0xFFFF))
EndFunc   ;==>_MakeLong


;=====================================================================
; by PortalDeamon000
Func _Update()
	FileDelete(@ScriptDir & "\version.dat")
	InetGet("http://www.portaldeamon.com/VersionKCH.txt", @ScriptDir & "\version.dat", 1, 0)
	$version = FileRead(@ScriptDir & "\version.dat")
	if FileGetSize(@ScriptDir & "\version.dat") <> 19 Then
		FileDelete(@ScriptDir & "\version.dat")
		MsgBox(48, "Updater", "ERROR!" & @CRLF & "Update Site Not Found")
		Return
	EndIf
	if $version = $VersionInfo Then
		FileDelete(@ScriptDir & "\version.dat")
		MsgBox(0, "Updater", "No New Updates")
		Return
	Else
		FileDelete(@ScriptDir & "\version.dat")
		$return = MsgBox(49, $VersionInfo, $version & " is avaiable for download." & @CRLF & "Click OK to download." )
		if $return = 1 Then ShellExecute("http://www.portaldeamon.com/kch_latest_release.zip")
		Return
	EndIf
EndFunc